/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class DHBMParameter
extends CMPDerObject {
    private AlgorithmId owf;
    private AlgorithmId mac;

    public DHBMParameter(AlgorithmId algorithmId, AlgorithmId algorithmId2) {
        if (algorithmId == null) {
            throw new IllegalArgumentException("DHBMParameter error, owf not specified");
        }
        if (algorithmId2 == null) {
            throw new IllegalArgumentException("DHBMParameter error, owf not specified");
        }
        this.owf = algorithmId;
        this.mac = algorithmId2;
    }

    public DHBMParameter(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new DHBMParameter(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("DHBMParamter parsing error, not a SEQUENCE");
        }
        if (derValue.getData().available() == 0) {
            throw new IOException("DHBMParamter parsing error, missing data");
        }
        this.owf = AlgorithmId.parse(derValue.getData().getDerValue());
        if (derValue.getData().available() == 0) {
            throw new IOException("DHBMParamter parsing error, missing data");
        }
        this.mac = AlgorithmId.parse(derValue.getData().getDerValue());
        if (derValue.getData().available() != 0) {
            throw new IOException("DHBMParamter parsing erro, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.owf == null) {
            throw new IOException("DHBMParamter encoding error, owf not specified");
        }
        this.owf.encode(derOutputStream);
        if (this.mac == null) {
            throw new IOException("DHBMParamter encoding error, mac not specified");
        }
        this.mac.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(DHBMParameter dHBMParameter) {
        DerValue derValue;
        DerValue derValue2;
        if (dHBMParameter == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            dHBMParameter.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof DHBMParameter) {
            return this.equals((DHBMParameter)object);
        }
        return false;
    }

    public AlgorithmId getMac() throws IOException {
        if (this.mac == null) {
            return null;
        }
        return new AlgorithmId(this.mac.getOID(), this.mac.getParameters());
    }

    public AlgorithmId getOwf() throws IOException {
        if (this.owf == null) {
            return null;
        }
        return new AlgorithmId(this.owf.getOID(), this.owf.getParameters());
    }

    public String toString() {
        String string = "DHBMParameter:";
        string = String.valueOf(string) + "\r\n\towf: " + this.owf.toString();
        string = String.valueOf(string) + "\r\n\tmac: " + this.mac.toString();
        return string;
    }
}

