/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.PKIFreeText;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public final class PKIStatusInfo
extends CMPDerObject {
    public static final int STATUS_GRANTED = 0;
    public static final int STATUS_GRANTED_WITH_MODS = 1;
    public static final int STATUS_REJECTION = 2;
    public static final int STATUS_WAITING = 3;
    public static final int STATUS_REVOCATION_WARNING = 4;
    public static final int STATUS_REVOCATION_NOTIFICATION = 5;
    public static final int STATUS_KEY_UPDATE_WARNING = 6;
    private int status;
    private PKIFreeText statusString;
    private boolean[] failInfo;

    public PKIStatusInfo(int n2, PKIFreeText pKIFreeText, boolean[] blArray) {
        if (n2 < 0 || n2 > 6) {
            throw new IllegalArgumentException("PKIStatusInfo error, invalid status specified");
        }
        this.status = n2;
        this.statusString = pKIFreeText;
        this.failInfo = blArray;
    }

    public PKIStatusInfo(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new PKIStatusInfo(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        int n2;
        if (derValue.getTag() != 48) {
            throw new IOException("PKIStatusInfo parsing error, not a SEQUENCE");
        }
        if (derValue.getData().available() == 0) {
            throw new IOException("PKIStatusInfo parsing error, not enough data");
        }
        try {
            n2 = derValue.getData().getInteger().intValue();
        }
        catch (Exception exception) {
            throw new IOException("PKIStatusInfo parsing error, invalid status");
        }
        if (n2 < 0 || n2 > 6) {
            throw new IOException("PKIStatusInfo parsing error, invalid status");
        }
        this.status = n2;
        this.statusString = null;
        this.failInfo = null;
        if (derValue.getData().available() == 0) {
            return;
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() == 48) {
            this.statusString = new PKIFreeText(derValue2.toByteArray());
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
            } else {
                return;
            }
        }
        if (derValue2.getTag() == 3) {
            try {
                this.failInfo = derValue2.getUnalignedBitString().toBooleanArray();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.failInfo = null;
            }
        } else {
            throw new IOException("PKIStatusInfo parsing error, extra data");
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("PKIStatusInfo parsing error, extra data");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.status));
        if (this.statusString != null) {
            this.statusString.encode(derOutputStream);
        }
        if (this.failInfo != null) {
            derOutputStream.putUnalignedBitString(new BitArray(this.failInfo));
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(PKIStatusInfo pKIStatusInfo) {
        DerValue derValue;
        DerValue derValue2;
        if (pKIStatusInfo == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKIStatusInfo.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PKIStatusInfo) {
            return this.equals((PKIStatusInfo)object);
        }
        return false;
    }

    public boolean[] getFailureInfos() {
        if (this.failInfo == null) {
            return null;
        }
        return (boolean[])this.failInfo.clone();
    }

    public int getStatus() {
        return this.status;
    }

    public PKIFreeText getStatusString() {
        if (this.statusString == null) {
            return null;
        }
        return (PKIFreeText)this.statusString.clone();
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "PKIStatusInfo :\r\n";
        switch (this.status) {
            case 0: {
                string = String.valueOf(string) + "\r\n\t Granted";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "\r\n\t Granted with mods";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "\r\n\t Rejection";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "\r\n\t Waiting";
                break;
            }
            case 5: {
                string = String.valueOf(string) + "\r\n\t Revocation notification";
                break;
            }
            case 6: {
                string = String.valueOf(string) + "\r\n\t Key update warning";
                break;
            }
        }
        if (this.statusString != null) {
            string = String.valueOf(string) + "\r\n\tstatus string: " + this.statusString;
        }
        if (this.failInfo != null) {
            string = String.valueOf(string) + "\r\n\tfail info: ";
            int n2 = 0;
            while (n2 < this.failInfo.length) {
                string = String.valueOf(string) + " failInfo[" + n2 + "]=" + this.failInfo[n2];
                ++n2;
            }
        }
        return string;
    }
}

