/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CertId;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CRLExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Date;

public final class RevAnnContent
extends CMPDerObject {
    private BigInteger status;
    private CertId certId;
    private Date willBeRevokedAt;
    private Date badSinceDate;
    private CRLExtensions crlDetails;
    private static final String GRANTED = "granted";
    private static final String GRANTED_WITH_MODS = "grantedWithMods";
    private static final String REJECTION = "rejection";
    private static final String WAITING = "waiting";
    private static final String REVOCATION_WARNING = "revocationWarning";
    private static final String REVOCATION_NOTIFICATION = "revocationNotification";
    private static final String KEY_UPDATE_WARNING = "keyUpdateWarning";
    private static final String[] PKIStatus = new String[]{"granted", "grantedWithMods", "rejection", "waiting", "revocationWarning", "revocationNotification", "keyUpdateWarning"};

    public RevAnnContent(BigInteger bigInteger, CertId certId, Date date, Date date2, CRLExtensions cRLExtensions) throws IOException {
        if (bigInteger == null) {
            throw new IllegalArgumentException("RevAnnContent error, status not specified");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(0L)) < 0 || bigInteger.compareTo(BigInteger.valueOf(6L)) > 0) {
            throw new IllegalArgumentException("RevAnnContent error, invalid status");
        }
        if (certId == null) {
            throw new IllegalArgumentException("RevAnnContent error, certId not specified");
        }
        if (date == null) {
            throw new IllegalArgumentException("RevAnnContent error, willBeRevokedAt not specified");
        }
        if (date2 == null) {
            throw new IllegalArgumentException("RevAnnContent error, badSinceDate not specified");
        }
        this.status = bigInteger;
        this.certId = certId;
        this.willBeRevokedAt = date;
        this.badSinceDate = date2;
        this.crlDetails = cRLExtensions;
    }

    public RevAnnContent(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new RevAnnContent(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("RevAnnContent parsing error, not a SEQUENCE");
        }
        this.status = null;
        this.certId = null;
        this.willBeRevokedAt = null;
        this.badSinceDate = null;
        this.crlDetails = null;
        this.status = derValue.getData().getInteger();
        if (this.status.compareTo(BigInteger.valueOf(0L)) < 0 || this.status.compareTo(BigInteger.valueOf(6L)) > 0) {
            throw new IOException("RevAnnContent parsing error, Invalid status");
        }
        if (derValue.getData().available() == 0) {
            throw new IOException("RevAnnContent parsing error, missing data");
        }
        this.certId = new CertId(derValue.getData().getDerValue().toByteArray());
        if (derValue.getData().available() == 0) {
            throw new IOException("RevAnnContent parsing error, missing data");
        }
        this.willBeRevokedAt = derValue.getData().getGeneralizedTime();
        if (derValue.getData().available() == 0) {
            throw new IOException("RevAnnContent parsing error, missing data");
        }
        this.badSinceDate = derValue.getData().getGeneralizedTime();
        if (derValue.getData().available() != 0) {
            try {
                this.crlDetails = new CRLExtensions(new DerInputStream(derValue.getData().getDerValue().toByteArray()));
            }
            catch (CRLException cRLException) {
                throw new IOException("RevAnnContent parsing error, " + cRLException);
            }
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("RevAnnContent parsing error, data overrun ");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.status == null) {
            throw new IOException("RevAnnContent encoding error, status not specified");
        }
        derOutputStream.putInteger(this.status);
        if (this.certId == null) {
            throw new IOException("RevAnnContent encoding error, certId not specified");
        }
        this.certId.encode(derOutputStream);
        if (this.willBeRevokedAt == null) {
            throw new IOException("RevAnnContent encoding error, willBeRevokedAt not specified");
        }
        derOutputStream.putGeneralizedTime(this.willBeRevokedAt);
        if (this.badSinceDate == null) {
            throw new IOException("RevAnnContent encoding error, badSinceDate not specified");
        }
        derOutputStream.putGeneralizedTime(this.badSinceDate);
        if (this.crlDetails != null) {
            try {
                this.crlDetails.encode(derOutputStream, true);
            }
            catch (CRLException cRLException) {
                throw new IOException("RevAnnContent encoding error, " + cRLException);
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(RevAnnContent revAnnContent) {
        DerValue derValue;
        DerValue derValue2;
        if (revAnnContent == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            revAnnContent.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof RevAnnContent) {
            return this.equals((RevAnnContent)object);
        }
        return false;
    }

    public Date getBadSinceDate() {
        return new Date(this.badSinceDate.getTime());
    }

    public CertId getCertId() {
        return (CertId)this.certId.clone();
    }

    public CRLExtensions getCrlDetails() throws IOException {
        if (this.crlDetails == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.crlDetails.encode(derOutputStream, true);
            return new CRLExtensions(new DerInputStream(derOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public BigInteger getStatus() {
        return new BigInteger(this.status.toByteArray());
    }

    public Date getWillBeRevokedAt() {
        return new Date(this.willBeRevokedAt.getTime());
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "RevAnnContent:\r\n";
        string = String.valueOf(string) + "\r\n\tstatus: ";
        string = String.valueOf(string) + PKIStatus[this.status.intValue()];
        string = String.valueOf(string) + "\r\n\tcertId: " + this.certId.toString();
        string = String.valueOf(string) + "\r\n\twillBeRevokedAt: " + this.willBeRevokedAt.toString();
        string = String.valueOf(string) + "\r\n\tbadSinceDate: " + this.badSinceDate.toString();
        if (this.crlDetails != null) {
            string = String.valueOf(string) + "\r\n\rcrlDetails: " + this.crlDetails.toString();
        }
        return string;
    }
}

