/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.PKMACValue;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;

public final class POPOSigningKeyInput
extends CMPDerObject {
    private GeneralName sender;
    private PKMACValue publicKeyMAC;
    private X509Key publicKey;
    private static final byte TAG_SENDER = 0;
    private static final byte TAG_PUBLIC_KEY_MAC = 1;
    private boolean bSender;

    public POPOSigningKeyInput(PKMACValue pKMACValue, PublicKey publicKey) {
        if (pKMACValue == null) {
            throw new IllegalArgumentException("POPOSigningKey error, public key MAC not specified");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("POPOSigningKey error, public key not specified");
        }
        this.publicKeyMAC = pKMACValue;
        this.bSender = false;
        try {
            this.publicKey = new X509Key();
            byte[] byArray = publicKey.getEncoded();
            this.publicKey.decode(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("POPOSigningKey error, invalid public key.  The key must be in X.509 format.");
        }
    }

    public POPOSigningKeyInput(GeneralName generalName, PublicKey publicKey) {
        if (generalName == null) {
            throw new IllegalArgumentException("POPOSigningKey error, sender not specified");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("POPOSigningKey error, public key not specified");
        }
        this.sender = generalName;
        this.bSender = true;
        try {
            this.publicKey = new X509Key();
            byte[] byArray = publicKey.getEncoded();
            this.publicKey.decode(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("POPOSigningKey error, invalid public key.  The key must be in X.509 format.");
        }
    }

    public POPOSigningKeyInput(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new POPOSigningKeyInput(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("POPOSigningKey parsing error, not a SEQUENCE");
        }
        if (derValue.getData().available() == 0) {
            throw new IOException("POPOSigningKey parsing error, missing data");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.sender = null;
        this.publicKeyMAC = null;
        this.publicKey = null;
        if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
            this.sender = new GeneralName(derValue2.getData().getDerValue());
            this.bSender = true;
        } else if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
            this.publicKeyMAC = new PKMACValue(derValue2.getData().getDerValue().toByteArray());
            this.bSender = false;
        } else {
            throw new IOException("POPOSigningKeyInput parsing error, invalid tag");
        }
        if (derValue.getData().available() == 0) {
            throw new IOException("POPOSigningKey parsing error, data missing");
        }
        try {
            PublicKey publicKey = X509Key.parse(derValue.getData().getDerValue());
            this.publicKey = new X509Key();
            this.publicKey.decode(publicKey.getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("POPOSigningKey parsing erro, error decoding public key; the key must be in X.509 format.");
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("POPOSigningKey parsing error, data overrun");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.bSender) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (this.sender == null) throw new IOException("POPOSigningKey encoding error, sender not specified");
            this.sender.encode(derOutputStream3);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        } else {
            if (this.publicKeyMAC == null) throw new IOException("POPOSigningKey encoding error, public key MAC not specified");
            DerOutputStream derOutputStream4 = new DerOutputStream();
            this.publicKeyMAC.encode(derOutputStream4);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream4);
        }
        if (this.publicKey == null) throw new IOException("POPOSigningKey encoding error, public key not specified");
        try {
            derOutputStream.write(this.publicKey.encode());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Error encoding public key.");
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(POPOSigningKeyInput pOPOSigningKeyInput) {
        DerValue derValue;
        DerValue derValue2;
        if (pOPOSigningKeyInput == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pOPOSigningKeyInput.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof POPOSigningKeyInput) {
            return this.equals((POPOSigningKeyInput)object);
        }
        return false;
    }

    public PublicKey getPublicKey() throws InvalidKeyException, IOException {
        DerValue derValue = new DerValue(this.publicKey.getEncoded());
        return X509Key.parse(derValue);
    }

    public PKMACValue getPublicKeyMAC() {
        if (this.publicKeyMAC == null) {
            return null;
        }
        return (PKMACValue)this.publicKeyMAC.clone();
    }

    public GeneralName getSender() {
        if (this.sender == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.sender.encode(derOutputStream);
            return new GeneralName(new DerValue(derOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isSender() {
        return this.bSender;
    }

    public String toString() {
        String string = "";
        string = this.bSender ? String.valueOf(string) + "sender: " + this.sender.toString() : String.valueOf(string) + "publicKeyMAC: " + this.publicKeyMAC.toString();
        string = String.valueOf(string) + "\r\npublic key: " + this.publicKey.toString();
        return string;
    }
}

