/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class SecretBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid;
    private byte[] value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.SecretBag";
    private volatile int cachedHashVal = 0;

    public SecretBag(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SecretBag", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "SecretBag");
        }
    }

    public SecretBag(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SecretBag", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "SecretBag");
        }
    }

    public SecretBag(ObjectIdentifier oid, byte[] obj) {
        if (debug != null) {
            debug.entry(16384L, className, "SecretBag", oid, obj);
            debug.exit(16384L, className, "SecretBag");
        }
        this.oid = oid;
        this.value = obj;
    }

    public SecretBag(ObjectIdentifier oid, byte[] obj, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{oid, obj, provider};
            debug.entry(16384L, (Object)className, "SecretBag", parms);
            debug.exit(16384L, className, "SecretBag");
        }
        this.oid = oid;
        this.value = obj;
    }

    public SecretBag(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SecretBag", filename, new Boolean(base64));
            debug.exit(16384L, className, "SecretBag");
        }
    }

    public SecretBag(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SecretBag", parms);
            debug.exit(16384L, className, "SecretBag");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putOID(this.oid);
        DerOutputStream tmpout = new DerOutputStream();
        tmpout.write(this.value);
        DerValue der = new DerValue(this.value);
        if (der.isConstructed()) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        } else {
            bytes.write(DerValue.createTag((byte)-128, false, (byte)0), tmpout);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier an_oid = null;
        try {
            an_oid = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception e2) {
            an_oid = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", an_oid);
        }
        return an_oid;
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.value.clone());
        }
        return this.value.clone();
    }

    @Override
    public byte[] getEncodedValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
            debug.exit(16384L, (Object)className, "getEncodedValue", (byte[])this.value.clone());
        }
        return (byte[])this.value.clone();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "SecretBag");
        }
        return "SecretBag";
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof SecretBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((SecretBag)other));
            }
            return this.equals((SecretBag)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SecretBag retobj = new SecretBag(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    public String toString() {
        HexDumpEncoder hd = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "SecretBag:";
        out = out + "\r\nobject identifier: " + this.oid;
        out = out + "\r\nvalue:\r\n" + hd.encodeBuffer(this.value);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SecretBag parsing error, not a SEQUENCE.");
            }
            throw new IOException("SecretBag parsing error, not a SEQUENCE.");
        }
        this.oid = encoding.getData().getOID();
        DerValue der = encoding.getData().getDerValue();
        if (der.isContextSpecific((byte)0)) {
            DerValue der2 = der.getData().getDerValue();
            this.value = der2.toByteArray();
        } else {
            this.value = der.toByteArray();
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(SecretBag other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e2);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

