/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class ShroudedKeyBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid = PKCSOID.SHROUDEDKEYBAG_OID;
    private EncryptedPrivateKeyInfo value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.ShroudedKeyBag";
    private volatile int cachedHashVal = 0;

    public ShroudedKeyBag(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ShroudedKeyBag", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
    }

    public ShroudedKeyBag(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "ShroudedKeyBag", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
    }

    public ShroudedKeyBag(EncryptedPrivateKeyInfo keyInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ShroudedKeyBag", keyInfo);
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
        this.value = keyInfo;
    }

    public ShroudedKeyBag(EncryptedPrivateKeyInfo keyInfo, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "ShroudedKeyBag", keyInfo, provider);
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
        this.value = keyInfo;
    }

    public ShroudedKeyBag(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "ShroudedKeyBag", filename, new Boolean(base64));
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
    }

    public ShroudedKeyBag(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "ShroudedKeyBag", parms);
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.value.encode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.SHROUDEDKEYBAG_OID);
        }
        return PKCSOID.SHROUDEDKEYBAG_OID;
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.value.clone());
        }
        return this.value.clone();
    }

    @Override
    public byte[] getEncodedValue() {
        DerOutputStream derout = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
        }
        try {
            this.value.encode(derout);
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedValue", e2);
                debug.exit(16384L, (Object)className, "getEncodedValue_1", null);
            }
            return null;
        }
        byte[] retval = derout.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncodedValue_2", retval);
        }
        return retval;
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "ShroudedKeyBag");
        }
        return "ShroudedKeyBag";
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof ShroudedKeyBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((ShroudedKeyBag)other));
            }
            return this.equals((ShroudedKeyBag)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            ShroudedKeyBag retbag = new ShroudedKeyBag(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retbag);
            }
            return retbag;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "ShroudedKeyBag:";
        out = out + "\r\nobject identifier: " + this.oid;
        out = out + "\r\nencrypted private key info:\r\n";
        out = out + this.value.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        this.value = new EncryptedPrivateKeyInfo(encoding.toByteArray(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", this.value);
        }
    }

    private boolean equals(ShroudedKeyBag other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e2);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

