/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public class SmudgedChars {
    private char fudgeFactor;
    private char[] contents;
    private String provider = null;
    private static Random generator;
    private static Debug debug;
    private static String className;

    public SmudgedChars(char[] input) {
        byte[] tempBytes = new byte[2];
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SmudgedChars", (Object)input);
        }
        do {
            generator.nextBytes(tempBytes);
            this.fudgeFactor = (char)(tempBytes[0] * 256 + tempBytes[1]);
        } while (this.fudgeFactor == '\u0000');
        this.contents = new char[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            this.contents[i2] = (char)(input[i2] + this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SmudgedChars");
        }
    }

    public SmudgedChars(char[] input, String provider) {
        if (debug != null) {
            debug.entry(16384L, className, "SmudgedChars", input, provider);
        }
        byte[] tempBytes = new byte[2];
        if (provider != null) {
            this.provider = new String(provider);
        }
        do {
            generator.nextBytes(tempBytes);
            this.fudgeFactor = (char)(tempBytes[0] * 256 + tempBytes[1]);
        } while (this.fudgeFactor == '\u0000');
        this.contents = new char[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            this.contents[i2] = (char)(input[i2] + this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SmudgedChars");
        }
    }

    public char[] getClearText() {
        char[] output = new char[this.contents.length];
        if (debug != null) {
            debug.entry(16384L, className, "getClearText");
        }
        for (int i2 = 0; i2 < this.contents.length; ++i2) {
            output[i2] = (char)(this.contents[i2] - this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getClearText", output);
        }
        return output;
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, className, "finalize");
        }
        if (this.contents != null) {
            Arrays.fill(this.contents, ' ');
            this.contents = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "finalize");
        }
    }

    static {
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.pkcsutil.SmudgedChars";
        generator = new Random(new Date().getTime());
    }
}

