/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

class UTFUtils {
    UTFUtils() {
    }

    static StringBuilder fromUTF(byte[] data) {
        byte in;
        int hold = 0;
        int dataSize = data.length;
        StringBuilder bfr = new StringBuilder();
        int off = 0;
        block6: while (off < dataSize && ((in = data[off++]) != 0 || off != dataSize)) {
            switch (in & 0xF0) {
                case 192: 
                case 208: {
                    hold = (in & 0x1F) << 6;
                    if (off < dataSize) break;
                    throw new IllegalArgumentException();
                }
                case 224: {
                    hold = (in & 0xF) << 12;
                    if (off >= dataSize - 1) {
                        throw new IllegalArgumentException();
                    }
                    if (((in = data[off++]) & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    if ((hold += (in & 0x3F) << 6) <= 55295 || hold >= 49152) break;
                    throw new IllegalArgumentException();
                }
                case 0: 
                case 16: 
                case 32: 
                case 48: 
                case 64: 
                case 80: 
                case 96: 
                case 112: {
                    bfr.append((char)in);
                    continue block6;
                }
                case 240: {
                    hold = (in & 0xF) << 18;
                    if (off >= dataSize - 2) {
                        throw new IllegalArgumentException();
                    }
                    if (((in = data[off++]) & 0xC0) == 128) {
                        hold += (in & 0x3F) << 12;
                    }
                    if (((in = data[off++]) & 0xC0) == 128) {
                        hold += (in & 0x3F) << 6;
                    }
                    if (((in = data[off++]) & 0xC0) == 128) {
                        UTFUtils.toUTF16(hold + (in & 0x3F), bfr);
                        continue block6;
                    }
                    throw new IllegalArgumentException();
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (((in = data[off++]) & 0xC0) == 128) {
                bfr.append((char)(hold + (in & 0x3F)));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return bfr;
    }

    static StringBuilder fromUniv(byte[] data) {
        int hold = 0;
        int dataSize = data.length;
        StringBuilder bfr = new StringBuilder();
        if ((dataSize & 3) != 0) {
            throw new IllegalArgumentException();
        }
        for (int off = 0; off < dataSize; off += 4) {
            if (data[off] != 0) {
                throw new IllegalArgumentException();
            }
            hold = (data[off + 1] << 16) + (data[off + 2] << 8);
            if ((hold += data[off + 3]) > 65535) {
                UTFUtils.toUTF16(hold, bfr);
                continue;
            }
            if (hold < 55296 || hold > 57343) {
                bfr.append((char)hold);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return bfr;
    }

    private static int fromUTF16(char a2, char b2) {
        if (a2 < '\ud800' || a2 > '\udbff' || b2 < '\udc00' || b2 > '\udfff') {
            return 0;
        }
        int val = (a2 & 0x3FF) << 10;
        return val + 65536 + (b2 & 0x3FF);
    }

    private static void toUTF16(int in, StringBuilder out) {
        int work = in - 65536;
        if (work > 1048575 || work < 0) {
            throw new IllegalArgumentException();
        }
        out.append((char)((work >> 10) + 55296));
        out.append((char)((work & 0x3FF) + 56320));
    }

    static byte[] toUTF(String in) {
        char chk;
        int i2;
        int j2 = i2 = in.length();
        while (--j2 >= 0) {
            chk = in.charAt(j2);
            if ((chk & 0xFF80) == 0) continue;
            if ((chk & 0xF800) == 0) {
                ++i2;
                continue;
            }
            i2 += chk > '\ud7ff' && chk < '\uc000' ? 1 : 2;
        }
        int dataSize = i2;
        byte[] data = new byte[i2];
        j2 = 0;
        i2 = 0;
        while (j2 < dataSize) {
            chk = in.charAt(i2);
            if ((chk & 0xFF80) == 0) {
                data[j2++] = (byte)chk;
            } else {
                if ((chk & 0xF800) != 0) {
                    if (chk > '\ud7ff' && chk < '\uc000') {
                        int hi = UTFUtils.fromUTF16(chk, in.charAt(++i2));
                        data[j2++] = (byte)(0xF0 | hi >> 18);
                        data[j2++] = (byte)(0x80 | hi >> 12 & 0x3F);
                        data[j2++] = (byte)(0x80 | hi >> 6 & 0x3F);
                    } else {
                        data[j2++] = (byte)(0xE0 | chk >> 12);
                        data[j2++] = (byte)(0x80 | chk >> 6 & 0x3F);
                    }
                } else {
                    data[j2++] = (byte)(0xC0 | chk >> 6);
                }
                data[j2++] = (byte)(0x80 | chk & 0x3F);
            }
            ++i2;
        }
        return data;
    }

    static byte[] toUniv(String in) {
        char chk;
        int i2;
        int j2 = i2 = in.length();
        while (--j2 >= 0) {
            chk = in.charAt(j2);
            if (chk <= '\ud7ff' || chk >= '\udc00') continue;
            --i2;
        }
        int dataSize = i2 * 4;
        byte[] data = new byte[dataSize];
        j2 = 0;
        i2 = 0;
        while (j2 < dataSize) {
            chk = in.charAt(i2);
            if ((chk & 0xFF80) == 0) {
                data[j2++] = (byte)chk;
            } else {
                if ((chk & 0xF800) != 0) {
                    if (chk > '\ud7ff' && chk < '\uc000') {
                        int hi = UTFUtils.fromUTF16(chk, in.charAt(++i2));
                        data[j2++] = (byte)(0xF0 | hi >> 18);
                        data[j2++] = (byte)(0x80 | hi >> 12 & 0x3F);
                        data[j2++] = (byte)(0x80 | hi >> 6 & 0x3F);
                    } else {
                        data[j2++] = (byte)(0xE0 | chk >> 12);
                        data[j2++] = (byte)(0x80 | chk >> 6 & 0x3F);
                    }
                } else {
                    data[j2++] = (byte)(0xC0 | chk >> 6);
                }
                data[j2++] = (byte)(0x80 | chk & 0x3F);
            }
            ++i2;
        }
        return data;
    }
}

