/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util.calendar;

import com.ibm.security.util.calendar.CalendarDate;
import com.ibm.security.util.calendar.Era;
import com.ibm.security.util.calendar.Gregorian;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public abstract class CalendarSystem {
    static Map names;
    static Map calendars;
    private static final String pkg = "sun.util.calendar.";
    private static final String[] namePairs;
    private static final Gregorian GREGORIAN_INSTANCE;

    private static synchronized void initNames() {
        if (names != null) {
            return;
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        StringBuilder clName = new StringBuilder();
        for (int i2 = 0; i2 < namePairs.length; i2 += 2) {
            clName.setLength(0);
            String cl = clName.append(pkg).append(namePairs[i2 + 1]).toString();
            nameMap.put(namePairs[i2], cl);
            calendars.put(cl, clName.append(".Date").toString());
        }
        names = nameMap;
    }

    public static Gregorian getGregorianCalendar() {
        return GREGORIAN_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarSystem forName(String calendarName) {
        if ("gregorian".equals(calendarName)) {
            return GREGORIAN_INSTANCE;
        }
        CalendarSystem cal = null;
        Map map = calendars;
        synchronized (map) {
            String className;
            cal = (CalendarSystem)calendars.get(calendarName);
            if (cal != null) {
                return cal;
            }
            if (names == null) {
                CalendarSystem.initNames();
            }
            if ((className = (String)names.get(calendarName)) == null) {
                return null;
            }
            if (!className.endsWith("LocalGregorianCalendar")) {
                try {
                    Class<?> cl = Class.forName(className);
                    cal = (CalendarSystem)cl.newInstance();
                    calendars.put(calendarName, cal);
                    return cal;
                }
                catch (Exception e2) {
                    throw new RuntimeException("internal error", e2);
                }
            }
        }
        return cal;
    }

    public abstract String getName();

    public abstract CalendarDate getCalendarDate();

    public abstract CalendarDate getCalendarDate(long var1);

    public abstract CalendarDate getCalendarDate(long var1, CalendarDate var3);

    public abstract CalendarDate getCalendarDate(long var1, TimeZone var3);

    public abstract CalendarDate newCalendarDate();

    public abstract CalendarDate newCalendarDate(TimeZone var1);

    public abstract long getTime(CalendarDate var1);

    public abstract int getYearLength(CalendarDate var1);

    public abstract int getYearLengthInMonths(CalendarDate var1);

    public abstract int getMonthLength(CalendarDate var1);

    public abstract int getWeekLength();

    public abstract Era getEra(String var1);

    public abstract Era[] getEras();

    public abstract void setEra(CalendarDate var1, String var2);

    public abstract CalendarDate getNthDayOfWeek(int var1, int var2, CalendarDate var3);

    public abstract CalendarDate setTimeOfDay(CalendarDate var1, int var2);

    public abstract boolean validate(CalendarDate var1);

    public abstract boolean normalize(CalendarDate var1);

    static {
        calendars = new HashMap();
        namePairs = new String[]{"gregorian", "Gregorian", "julian", "JulianCalendar"};
        GREGORIAN_INSTANCE = new Gregorian();
    }
}

