/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertException;
import com.ibm.security.x509.CertParseError;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X500Signer;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Certificate;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;

public class X509Cert
implements Certificate,
Serializable {
    static final long serialVersionUID = -52595524744692374L;
    protected transient AlgorithmId algid;
    private transient byte[] rawCert;
    private transient byte[] signature;
    private transient byte[] signedCert;
    private transient X500Name subject;
    private transient PublicKey pubkey;
    private transient Date notafter;
    private transient Date notbefore;
    private transient int version;
    private transient BigInteger serialnum;
    private transient X500Name issuer;
    private transient AlgorithmId issuerSigAlg;
    private transient boolean parsed = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509Cert";

    public X509Cert() {
        if (debug != null) {
            debug.entry(16384L, className, "X509Cert");
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public X509Cert(byte[] cert) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509Cert", (Object)cert);
        }
        DerValue in = new DerValue(cert);
        this.parse(in);
        if (in.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "X509Cert", "garbage at end");
            }
            throw new CertParseError("garbage at end");
        }
        this.signedCert = cert;
        if (debug != null) {
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public X509Cert(byte[] buf, int offset, int len) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset), new Integer(len)};
            debug.entry(16384L, (Object)className, "X509Cert", parms);
        }
        DerValue in = new DerValue(buf, offset, len);
        this.parse(in);
        if (in.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "X509Cert", "garbage at end");
            }
            throw new CertParseError("garbage at end");
        }
        this.signedCert = new byte[len];
        System.arraycopy(buf, offset, this.signedCert, 0, len);
        if (debug != null) {
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public X509Cert(DerValue derVal) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509Cert", derVal);
        }
        this.parse(derVal);
        if (derVal.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "X509Cert", "garbage at end");
            }
            throw new CertParseError("garbage at end");
        }
        this.signedCert = derVal.toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public X509Cert(X500Name subjectName, X509Key subjectPublicKey, Date notBefore, Date notAfter) throws CertException {
        if (debug != null) {
            Object[] parms = new Object[]{subjectName, subjectPublicKey, notBefore, notAfter};
            debug.entry(16384L, (Object)className, "X509Cert", parms);
        }
        this.subject = subjectName;
        if (!(subjectPublicKey instanceof PublicKey)) {
            if (debug != null) {
                debug.text(16384L, className, "X509Cert", "Doesn't implement PublicKey interface");
            }
            throw new CertException(9, "Doesn't implement PublicKey interface");
        }
        this.pubkey = subjectPublicKey;
        this.notbefore = notBefore;
        this.notafter = notAfter;
        this.version = 0;
        if (debug != null) {
            debug.exit(16384L, className, "X509Cert");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
        }
        DerValue val = new DerValue(in);
        this.parse(val);
        this.signedCert = val.toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.write(this.getSignedCert());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        boolean result = false;
        if (other instanceof X509Cert) {
            result = this.equals((X509Cert)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(result));
        }
        return result;
    }

    public boolean equals(X509Cert src) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", src);
        }
        boolean result = true;
        if (this == src) {
            result = true;
        } else if (this.signedCert == null || src.signedCert == null) {
            result = false;
        } else if (this.signedCert.length != src.signedCert.length) {
            result = false;
        } else {
            for (int i2 = 0; i2 < this.signedCert.length; ++i2) {
                if (this.signedCert[i2] == src.signedCert[i2]) continue;
                result = false;
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", result);
        }
        return result;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public Principal getGuarantor() {
        return this.getIssuerName();
    }

    @Override
    public Principal getPrincipal() {
        return this.getSubjectName();
    }

    public void verify(PublicKey issuerPublicKey) throws CertException {
        Date now;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", issuerPublicKey);
        }
        if ((now = new Date()).before(this.notbefore)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate is not yet valid");
            }
            throw new CertException(3);
        }
        if (now.after(this.notafter)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate has expired");
            }
            throw new CertException(4);
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "?? certificate is not signed yet ??");
            }
            throw new CertException(1, "?? certificate is not signed yet ??");
        }
        String algName = null;
        try {
            Signature sigVerf = null;
            algName = this.issuerSigAlg.getName();
            sigVerf = Signature.getInstance(algName);
            sigVerf.initVerify(issuerPublicKey);
            sigVerf.update(this.rawCert, 0, this.rawCert.length);
            if (!sigVerf.verify(this.signature)) {
                if (debug != null) {
                    debug.text(16384L, className, "verify", "Signature ... by <" + this.issuer + "> for <" + this.subject + ">");
                }
                throw new CertException(1, "Signature ... by <" + this.issuer + "> for <" + this.subject + ">");
            }
        }
        catch (NoSuchAlgorithmException e2) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Unsupported signature algorithm (" + algName + ")");
            }
            throw new CertException(1, "Unsupported signature algorithm (" + algName + ")");
        }
        catch (InvalidKeyException e3) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Algorithm (" + algName + ") rejected public key");
            }
            throw new CertException(9, "Algorithm (" + algName + ") rejected public key");
        }
        catch (SignatureException e4) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature by <" + this.issuer + "> for <" + this.subject + ">");
            }
            throw new CertException(1, "Signature by <" + this.issuer + "> for <" + this.subject + ">");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public byte[] encodeAndSign(BigInteger serial, X500Signer issuer) throws IOException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "encodeAndSign", serial, issuer);
        }
        this.rawCert = null;
        this.version = 0;
        this.serialnum = serial;
        this.issuer = issuer.getSigner();
        this.issuerSigAlg = issuer.getAlgorithmId();
        if (this.subject == null || this.pubkey == null || this.notbefore == null || this.notafter == null) {
            if (debug != null) {
                debug.text(16384L, className, "encodeAndSign", "not enough cert parameters");
            }
            throw new IOException("not enough cert parameters");
        }
        this.rawCert = this.DERencode();
        this.signedCert = this.sign(issuer, this.rawCert);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encodeAndSign", this.signedCert);
        }
        return this.signedCert;
    }

    public X500Signer getSigner(AlgorithmId algorithmId, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "setSigner", algorithmId, privateKey);
        }
        if (!(privateKey instanceof Key)) {
            if (debug != null) {
                debug.text(16384L, className, "setSigner", "private key not a key!");
            }
            throw new InvalidKeyException("private key not a key!");
        }
        PrivateKey key = privateKey;
        String algorithm = key.getAlgorithm();
        Signature sig = Signature.getInstance(algorithmId.getName());
        if (!this.pubkey.getAlgorithm().equals(algorithm)) {
            if (debug != null) {
                debug.text(16384L, className, "setSigner", "Private key algorithm " + algorithm + " incompatible with certificate " + this.pubkey.getAlgorithm());
            }
            throw new InvalidKeyException("Private key algorithm " + algorithm + " incompatible with certificate " + this.pubkey.getAlgorithm());
        }
        sig.initSign(privateKey);
        X500Signer result = new X500Signer(sig, this.subject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "setSigner", result);
        }
        return result;
    }

    public Signature getVerifier(String algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getVerifier", algorithm);
        }
        Signature sig = Signature.getInstance(algorithm);
        sig.initVerify(this.pubkey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getVerifier", sig);
        }
        return sig;
    }

    public byte[] getSignedCert() {
        return (byte[])this.signedCert.clone();
    }

    public BigInteger getSerialNumber() {
        return this.serialnum;
    }

    public X500Name getSubjectName() {
        return this.subject;
    }

    public X500Name getIssuerName() {
        return this.issuer;
    }

    public AlgorithmId getIssuerAlgorithmId() {
        return this.issuerSigAlg;
    }

    public Date getNotBefore() {
        return new Date(this.notbefore.getTime());
    }

    public Date getNotAfter() {
        return new Date(this.notafter.getTime());
    }

    @Override
    public PublicKey getPublicKey() {
        return this.pubkey;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        int retval = 0;
        for (int i2 = 0; i2 < this.signedCert.length; ++i2) {
            retval += this.signedCert[i2] * i2;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public String toString() {
        if (this.subject == null || this.pubkey == null || this.notbefore == null || this.notafter == null || this.issuer == null || this.issuerSigAlg == null || this.serialnum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        String s2 = "  X.509v" + (this.version + 1) + " certificate,\n";
        s2 = s2 + "  Subject is " + this.subject + "\n";
        s2 = s2 + "  Key:  " + this.pubkey;
        s2 = s2 + "  Validity <" + this.notbefore + "> until <" + this.notafter + ">\n";
        s2 = s2 + "  Issuer is " + this.issuer + "\n";
        s2 = s2 + "  Issuer signature used " + this.issuerSigAlg.toString() + "\n";
        s2 = s2 + "  Serial number = " + this.serialnum + "\n";
        return "[\n" + s2 + "]";
    }

    @Override
    public String toString(boolean detailed) {
        return this.toString();
    }

    private void parse(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parse", val);
        }
        if (this.parsed) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "Certificate already parsed");
            }
            throw new IOException("Certificate already parsed");
        }
        DerValue[] seq = new DerValue[]{val.getData().getDerValue(), val.getData().getDerValue(), val.getData().getDerValue()};
        if (val.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed overrun, bytes = " + val.getData().available());
            }
            throw new CertParseError("signed overrun, bytes = " + val.getData().available());
        }
        if (seq[0].getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed fields invalid");
            }
            throw new CertParseError("signed fields invalid");
        }
        this.rawCert = seq[0].toByteArray();
        this.issuerSigAlg = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (seq[1].getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "algid field overrun");
            }
            throw new CertParseError("algid field overrun");
        }
        if (seq[2].getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed fields overrun");
            }
            throw new CertParseError("signed fields overrun");
        }
        DerInputStream in = seq[0].getData();
        this.version = 0;
        DerValue tmp = in.getDerValue();
        if (tmp.isConstructed() && tmp.isContextSpecific()) {
            this.version = tmp.getData().getInteger().intValue();
            if (tmp.getData().available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "parse", "X.509 version, bad format");
                }
                throw new IOException("X.509 version, bad format");
            }
            tmp = in.getDerValue();
        }
        this.serialnum = tmp.getInteger();
        tmp = in.getDerValue();
        AlgorithmId algid = AlgorithmId.parse(tmp);
        if (!algid.equals(this.issuerSigAlg)) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "CA Algorithm mismatch!");
            }
            throw new CertParseError("CA Algorithm mismatch!");
        }
        this.algid = algid;
        this.issuer = new X500Name(in);
        tmp = in.getDerValue();
        if (tmp.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "corrupt validity field");
            }
            throw new CertParseError("corrupt validity field");
        }
        this.notbefore = tmp.getData().getUTCTime();
        this.notafter = tmp.getData().getUTCTime();
        if (tmp.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "excess validity data");
            }
            throw new CertParseError("excess validity data");
        }
        this.subject = new X500Name(in);
        tmp = in.getDerValue();
        this.pubkey = X509Key.parse(tmp);
        if (in.available() != 0) {
            // empty if block
        }
        this.parsed = true;
        if (debug != null) {
            debug.exit(16384L, className, "parse");
        }
    }

    private byte[] DERencode() throws IOException {
        if (debug != null) {
            debug.exit(16384L, className, "DERencode");
        }
        DerOutputStream raw = new DerOutputStream();
        this.encode(raw);
        byte[] result = raw.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DERencode", result);
        }
        return result;
    }

    private void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        tmp.putInteger(this.serialnum);
        this.issuerSigAlg.encode(tmp);
        this.issuer.encode(tmp);
        DerOutputStream seq = new DerOutputStream();
        seq.putUTCTime(this.notbefore);
        seq.putUTCTime(this.notafter);
        tmp.write((byte)48, seq);
        this.subject.encode(tmp);
        tmp.write(this.pubkey.getEncoded());
        out.write((byte)48, tmp);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    private byte[] sign(X500Signer issuer, byte[] data) throws IOException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", issuer, data);
        }
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        tmp.write(data);
        issuer.getAlgorithmId().encode(tmp);
        issuer.update(data, 0, data.length);
        this.signature = issuer.sign();
        tmp.putBitString(this.signature);
        out.write((byte)48, tmp);
        byte[] result = out.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", result);
        }
        return result;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.encode(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this.decode(stream);
    }
}

