/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.OnePhaseXAResource;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.JTAResourceBase;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class OnePhaseResourceImpl
extends JTAResourceBase {
    private static final TraceComponent tc;
    private static final TraceComponent tcSummary;

    public OnePhaseResourceImpl(OnePhaseXAResource xares, Xid xid) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"OnePhaseResourceImpl", (Object[])new Object[]{xares, xid});
        }
        this._resource = xares;
        this._xid = xid;
        this.traceCreate();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"OnePhaseResourceImpl");
        }
    }

    @Override
    public final int prepare() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepare", (Object[])new Object[]{this._resource});
        }
        try {
            this._resource.prepare(this._xid);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepare");
            }
        }
        throw new XAException(105);
    }

    @Override
    public final void commit() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit", (Object[])new Object[]{this._resource});
        }
        Tr.warning((TraceComponent)tc, (String)"WTRN0018_1PC_RESOURCE_DOES_NOT_SUPPORT_COMMIT", (Object[])new Object[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit");
        }
        throw new XAException(-6);
    }

    @Override
    public final void commit_one_phase() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit_one_phase", (Object[])new Object[]{this._resource});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"commit_one_phase", (Object[])new Object[]{this});
        }
        try {
            this._resource.commit(this._xid, true);
            this._completedCommit = true;
            this._vote = JTAResource.JTAResourceVote.commit;
        }
        catch (XAException xae) {
            this._completionXARC = xae.errorCode;
            throw xae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit_one_phase", (Object)this._completionXARC);
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)("commit_one_phase result: " + XAReturnCodeHelper.convertXACode(this._completionXARC)), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public final void rollback() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback", (Object[])new Object[]{this._resource});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"rollback", (Object[])new Object[]{this});
        }
        try {
            this._resource.rollback(this._xid);
            this._vote = JTAResource.JTAResourceVote.rollback;
        }
        catch (XAException xae) {
            this._completionXARC = xae.errorCode;
            throw xae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback");
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)("rollback result: " + XAReturnCodeHelper.convertXACode(this._completionXARC)), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public final void forget() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forget", (Object[])new Object[]{this._resource});
            Tr.exit((TraceComponent)tc, (String)"forget");
        }
    }

    @Override
    public final void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[]{this._resource});
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OnePhaseResourceImpl) {
            return this._resource.equals(((OnePhaseResourceImpl)o)._resource);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this._resource.hashCode();
    }

    @Override
    public String describe() {
        return "Resource: " + ((OnePhaseXAResource)this._resource).getResourceName();
    }

    static {
        tcSummary = tc = Tr.register(OnePhaseResourceImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    }
}

