/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.ICompletionListener;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.concurrent.ExecutorService;

abstract class AbstractAsyncFuture
implements IAbstractAsyncFuture {
    private static final TraceComponent tc = Tr.register(AbstractAsyncFuture.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected final AbstractAsyncChannel channel;
    protected volatile Exception exception = null;
    protected volatile boolean completed = false;
    protected volatile boolean fullyCompleted = false;
    protected volatile int cancelInProgress = 0;
    protected volatile int reuseCount = 0;
    protected final Object completedSemaphore = new Object();
    protected ICompletionListener firstListener = null;
    protected Object firstListenerState = null;
    private WorkCallback myCallback = null;

    protected AbstractAsyncFuture(AbstractAsyncChannel channel) {
        this.channel = channel;
    }

    @Override
    public int getReuseCount() {
        return this.reuseCount;
    }

    @Override
    public Object getCompletedSemaphore() {
        return this.completedSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completed(Exception throwable) {
        boolean needToFire = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"completed", (Object[])new Object[]{throwable.getMessage()});
        }
        Object object = this.completedSemaphore;
        synchronized (object) {
            if (this.completed || !this.channel.isOpen()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Future completed after already cancelled or socket was closed", (Object[])new Object[0]);
                }
                return;
            }
            this.completed = true;
            if (this.getTimeoutWorkItem() != null) {
                this.getTimeoutWorkItem().state = 2L;
            }
            this.exception = throwable;
            if (this.firstListener == null) {
                needToFire = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("doing notify for future " + this), (Object[])new Object[0]);
                }
                this.completedSemaphore.notifyAll();
            }
        }
        if (needToFire) {
            this.fireCompletionActions();
        }
    }

    protected abstract void fireCompletionActions();

    protected void invokeCallback(ICompletionListener listener, AbstractAsyncFuture future, Object userState) {
        try {
            ExecutorService executorService = CHFWBundle.getExecutorService();
            if (null == executorService) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to schedule callback, using this thread", (Object[])new Object[0]);
                }
                listener.futureCompleted(future, userState);
            } else {
                if (null == this.myCallback) {
                    this.myCallback = new WorkCallback(listener, userState);
                } else {
                    this.myCallback.myListener = listener;
                    this.myCallback.myState = userState;
                }
                executorService.execute(this.myCallback);
            }
        }
        catch (Throwable problem) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error invoking callback, exception: " + problem + " : " + problem.getMessage()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)problem, (String)(this.getClass().getName() + ".invokeCallback"), (String)"182", (Object)this);
        }
    }

    @Override
    public abstract void addCompletionListener(ICompletionListener var1, Object var2);

    @Override
    public abstract void cancel(Exception var1);

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void setFullyCompleted(boolean newValue) {
        this.fullyCompleted = newValue;
    }

    public void setCancelInProgress(int newValue) {
        this.cancelInProgress = newValue;
    }

    public int getCancelInProgress() {
        return this.cancelInProgress;
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
        try {
            this.waitForCompletion(0L);
        }
        catch (AsyncTimeoutException ate) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected timeout on blocking wait call, exception: " + ate.getMessage()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)ate, (String)(this.getClass().getName() + ".waitForCompletion"), (String)"268", (Object)this);
            InterruptedException ie = new InterruptedException("Unexpected timeout");
            ie.initCause(ate);
            throw ie;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion(long timeout) throws AsyncTimeoutException, InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("waitForCompletion: " + timeout), (Object[])new Object[0]);
        }
        if (this.fullyCompleted) {
            return;
        }
        Object object = this.completedSemaphore;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("waiting for completion notification for future: " + this), (Object[])new Object[0]);
            }
            this.completedSemaphore.wait(timeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("done waiting for completion notification for future: " + this), (Object[])new Object[0]);
            }
        }
        if (this.fullyCompleted) {
            return;
        }
        object = this.completedSemaphore;
        synchronized (object) {
            if (!this.completed) {
                this.completed = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Sync operation timed out", (Object[])new Object[0]);
                }
                throw new AsyncTimeoutException();
            }
        }
    }

    public void resetFuture() {
        ++this.reuseCount;
        if (this.getTimeoutWorkItem() != null) {
            this.getTimeoutWorkItem().state = 2L;
        }
        this.setTimeoutWorkItem(null);
        this.completed = false;
        this.fullyCompleted = false;
        this.exception = null;
        this.firstListener = null;
        this.firstListenerState = null;
    }

    private class WorkCallback
    implements Runnable {
        protected ICompletionListener myListener;
        protected Object myState;

        protected WorkCallback(ICompletionListener listener, Object state) {
            this.myListener = listener;
            this.myState = state;
        }

        @Override
        public void run() {
            this.myListener.futureCompleted(AbstractAsyncFuture.this, this.myState);
        }
    }
}

