/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AbstractAsyncFuture;
import com.ibm.io.async.AsyncProperties;
import com.ibm.io.async.AsyncSocketChannel;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.Timer;
import com.ibm.io.async.TimerCallback;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class AsyncSocketChannelHelper {
    protected static final TraceComponent tc = Tr.register(AsyncSocketChannelHelper.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected static Timer timer = null;
    protected static AsyncTimeoutException timeoutException = null;
    private TimerCallback callback = new tCallback();
    protected final AsyncSocketChannel schannel;
    protected final boolean providerIsMultiCapable;

    public AsyncSocketChannelHelper(AsyncSocketChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException();
        }
        this.schannel = channel;
        this.providerIsMultiCapable = channel.isCapable(1);
    }

    public IAsyncFuture read(ByteBuffer[] bufs, boolean forceQueue, long bytesRequested, boolean useJITBuffer, VirtualConnection vci, boolean asyncIO) {
        return this.schannel.multiIO(bufs, 0L, true, forceQueue, bytesRequested, useJITBuffer, vci, asyncIO);
    }

    public IAsyncFuture read(ByteBuffer[] bufs, long timeout, boolean forceQueue, long bytesRequested, boolean useJITBuffer, VirtualConnection vci, boolean asyncIO) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        IAsyncFuture future = this.read(bufs, forceQueue, bytesRequested, useJITBuffer, vci, asyncIO);
        if (future != null && !future.isCompleted() && timeout > 0L) {
            this.createTimeout(future, timeout, true);
        }
        return future;
    }

    public IAsyncFuture write(ByteBuffer[] bufs, long timeout, boolean forceQueue, long bytesRequested, VirtualConnection vci, boolean asyncIO) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        IAsyncFuture future = this.write(bufs, forceQueue, bytesRequested, vci, asyncIO);
        if (future != null && !future.isCompleted() && timeout > 0L) {
            this.createTimeout(future, timeout, false);
        }
        return future;
    }

    public IAsyncFuture write(ByteBuffer[] bufs, boolean forceQueue, long bytesRequested, VirtualConnection vci, boolean asyncIO) {
        return this.schannel.multiIO(bufs, 0L, false, forceQueue, bytesRequested, false, vci, asyncIO);
    }

    public AsyncSocketChannel getChannel() {
        return this.schannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTimeout(IAbstractAsyncFuture future, long delay, boolean isRead) {
        if (AsyncProperties.disableTimeouts) {
            return;
        }
        long timeoutTime = System.currentTimeMillis() + delay + 1024L & 0xFFFFFFFFFFFFFC00L;
        Object object = future.getCompletedSemaphore();
        synchronized (object) {
            if (!future.isCompleted()) {
                timer.createTimeoutRequest(timeoutTime, this.callback, future);
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivStartTimer());
    }

    private static class tCallback
    implements TimerCallback {
        protected tCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timerTriggered(TimerWorkItem twi) {
            AbstractAsyncFuture theFuture = (AbstractAsyncFuture)twi.attachment;
            try {
                Object object = theFuture.getCompletedSemaphore();
                synchronized (object) {
                    if (!theFuture.isCompleted()) {
                        if (theFuture.getReuseCount() != twi.futureCount) {
                            return;
                        }
                        if (timeoutException == null) {
                            timeoutException = new AsyncTimeoutException();
                        }
                        theFuture.setCancelInProgress(1);
                        theFuture.cancel(timeoutException);
                    }
                }
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error in timerTriggered while trying to timeout an operation. exception: " + e.getMessage()), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"98", (Object)this);
            }
        }
    }

    static class PrivStartTimer
    implements PrivilegedAction<Object> {
        @Override
        public Object run() {
            timer = new Timer();
            return null;
        }
    }
}

