/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cloudant.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cloudant.internal.ClientKey;
import com.ibm.ws.cloudant.internal.CloudantService;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class CloudantApplicationListener
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(CloudantApplicationListener.class, (String)"cloudant", (String)"com.ibm.ws.cloudant.internal.resources.Messages");
    private final ConcurrentMap<CloudantService, ConcurrentMap<ClientKey, Object>> registrations = new ConcurrentHashMap<CloudantService, ConcurrentMap<ClientKey, Object>>();
    static final long serialVersionUID = 1355429464555203403L;

    public void applicationStarting(ApplicationInfo appInfo) {
    }

    public void applicationStarted(ApplicationInfo appInfo) {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        if (!this.registrations.isEmpty()) {
            String appName = appInfo.getName();
            for (ConcurrentMap cache : this.registrations.values()) {
                Iterator it = cache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry cacheEntry = it.next();
                    String identifier = ((ClientKey)cacheEntry.getKey()).getApplicationClassLoaderIdentifier();
                    if (identifier == null) continue;
                    int start = identifier.indexOf(58) + 1;
                    int len = appName.length();
                    if (start <= 0 || identifier.length() - start <= len || identifier.charAt(start + len) != '#' || !appName.equals(identifier.substring(start, start + len))) continue;
                    final Object client = cacheEntry.getValue();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"remove and shut down cached client", (Object[])new Object[]{client});
                    }
                    it.remove();
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){
                        static final long serialVersionUID = 5141266574129400078L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() {
                            try {
                                client.getClass().getMethod("shutdown", new Class[0]).invoke(client, new Object[0]);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.cloudant.internal.CloudantApplicationListener$1", (String)"78", (Object)this, (Object[])new Object[0]);
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.cloudant.internal.CloudantApplicationListener$1", 1.class, (String)"cloudant", (String)"com.ibm.ws.cloudant.internal.resources.Messages");
                        }
                    });
                }
            }
        }
    }

    void register(CloudantService svc, ConcurrentMap<ClientKey, Object> clients) {
        this.registrations.put(svc, clients);
    }

    void unregister(CloudantService svc) {
        this.registrations.remove(svc);
    }
}

