/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.metadata.ejb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.EJBModuleInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.ejbcontainer.EJBEndpoint;
import com.ibm.ws.ejbcontainer.EJBEndpoints;
import com.ibm.ws.ejbcontainer.EJBType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs.metadata.ArchiveInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.apache.wink.server.internal.lifecycle.metadata.EJBBeanMetadata;
import org.apache.wink.server.internal.lifecycle.metadata.EJBMetadata;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ArchiveInfoImpl
implements ArchiveInfo {
    private static final TraceComponent tc = Tr.register(ArchiveInfoImpl.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
    private String appName;
    private String moduleName;
    private EJBMetadata ejbMetadata;
    private Set<Class<?>> ejbClasses;
    static final long serialVersionUID = -7611952702393354736L;

    public Set<Class<?>> getEjbClasses() {
        if (null == this.ejbClasses) {
            this.ejbClasses = Collections.emptySet();
        }
        return this.ejbClasses;
    }

    public void setEjbClasses(Set<Class<?>> ejbClasses) {
        this.ejbClasses = ejbClasses;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public EJBMetadata getEjbMetadata() {
        return this.ejbMetadata;
    }

    public void setEjbMetadata(EJBMetadata ejbMetadata) {
        this.ejbMetadata = ejbMetadata;
    }

    public void addEJBMetadata(String interfaceName, EJBBeanMetadata beanMetadata) {
        if (this.ejbMetadata.getEjbMetadata() == null) {
            this.ejbMetadata.setEjbMetadata(new HashMap());
        }
        this.ejbMetadata.getEjbMetadata().put(interfaceName, beanMetadata);
    }

    @ManualTrace
    public void extractArchiveInfo(ModuleInfo moduleInfo) throws UnableToAdaptException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractArchiveInfo", (Object[])new Object[]{moduleInfo});
        }
        this.setEjbMetadata(new EJBMetadata());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Gathering metadata for module " + moduleInfo.getName()), (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Application name is " + moduleInfo.getApplicationInfo().getName()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Module name is " + moduleInfo.getName()), (Object[])new Object[0]);
        }
        this.setAppName(moduleInfo.getApplicationInfo().getName());
        this.setModuleName(moduleInfo.getName());
        EJBEndpoints endpoints = (EJBEndpoints)moduleInfo.getContainer().adapt(EJBEndpoints.class);
        List ejbList = endpoints.getEJBEndpoints();
        if (ejbList != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got a list of " + ejbList.size() + " session beans"), (Object[])new Object[0]);
            }
            HashSet ejbClasses = new HashSet();
            for (EJBEndpoint ejb : ejbList) {
                EJBType type = ejb.getEJBType();
                String beanName = ejb.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing bean " + beanName + " of type " + type), (Object[])new Object[0]);
                }
                if (type.isSession() && (type.equals((Object)EJBType.SINGLETON_SESSION) || type.equals((Object)EJBType.STATELESS_SESSION))) {
                    List interfaces;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Processing a singleton or stateless session bean.", (Object[])new Object[0]);
                    }
                    if ((interfaces = ejb.getLocalBusinessInterfaceNames()).size() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This is a no-interface bean. Checking the bean class directly for annotations", (Object[])new Object[0]);
                        }
                        this.processEJB(ejb, null, moduleInfo, ejbClasses);
                        continue;
                    }
                    for (String ifcName : interfaces) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Processing interface {0} of bean {1}", (Object[])new Object[]{ifcName, beanName});
                        }
                        this.processEJB(ejb, ifcName, moduleInfo, ejbClasses);
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Only stateless session or singleton session beans are supported in JAX-RS", (Object[])new Object[0]);
            }
            if (ejbClasses.size() > 0) {
                this.setEjbClasses(ejbClasses);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No EJB metadata to process.", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractArchiveInfo");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void getApplicationSubclasses(Set<Class<?>> classes, EJBEndpoint ejb, ModuleInfo moduleInfo) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getApplicationSubclasses", (Object[])new Object[0]);
            }
            try {
                Class<?> c;
                Class appClass;
                block8: {
                    appClass = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){
                        static final long serialVersionUID = 3450315843775882354L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Class run() throws Exception {
                            return Thread.currentThread().getContextClassLoader().loadClass(Application.class.getName());
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, null, null);
                        }
                    });
                    String ejbClassName = ejb.getClassName();
                    c = null;
                    try {
                        c = moduleInfo.getClassLoader().loadClass(ejbClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        void e;
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs.metadata.ejb.ArchiveInfoImpl", (String)"216", (Object)this, (Object[])new Object[]{classes, ejb, moduleInfo});
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug((TraceComponent)tc, (String)("getApplicationSubclasses() exit - due to Class Not Found for " + ejbClassName + ": " + e), (Object[])new Object[0]);
                    }
                }
                if (c != null && appClass.isAssignableFrom(c)) {
                    classes.add(c);
                }
            }
            catch (PrivilegedActionException appClass) {
                FFDCFilter.processException((Throwable)appClass, (String)"com.ibm.ws.jaxrs.metadata.ejb.ArchiveInfoImpl", (String)"227", (Object)this, (Object[])new Object[]{classes, ejb, moduleInfo});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("getPathClasses() exit - returning empty set due to PrivilegedActionException for " + Application.class.getName() + ": " + e), (Object[])new Object[0]);
                }
                if (!tc.isEntryEnabled()) break block9;
                Tr.exit((TraceComponent)tc, (String)"getApplicationSubclasses", Collections.emptySet());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationSubclasses", classes);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void getEJBWithProviderClasses(Set<Class<?>> classes, EJBEndpoint ejb, String ejbInterfaceName, ModuleInfo moduleInfo) {
        block10: {
            String methodName = "getEJBWithProviderClasses";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getEJBWithProviderClasses", (Object[])new Object[]{classes});
            }
            if (classes == null && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getEJBWithProviderClasses", Collections.emptySet());
            }
            try {
                Class<?> c;
                Class providerClass;
                block9: {
                    providerClass = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){
                        static final long serialVersionUID = -4667908710390860100L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Class run() throws Exception {
                            return Thread.currentThread().getContextClassLoader().loadClass(Provider.class.getName());
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class, null, null);
                        }
                    });
                    String ejbClassName = ejbInterfaceName == null ? ejb.getClassName() : ejbInterfaceName;
                    c = null;
                    try {
                        c = moduleInfo.getClassLoader().loadClass(ejbClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        void e;
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs.metadata.ejb.ArchiveInfoImpl", (String)"261", (Object)this, (Object[])new Object[]{classes, ejb, ejbInterfaceName, moduleInfo});
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug((TraceComponent)tc, (String)("getEJBWithProviderClasses() exit - due to Class Not Found for " + ejbClassName + ": " + e), (Object[])new Object[0]);
                    }
                }
                if (c != null && c.getAnnotation(providerClass) != null) {
                    classes.add(c);
                }
            }
            catch (PrivilegedActionException providerClass) {
                FFDCFilter.processException((Throwable)providerClass, (String)"com.ibm.ws.jaxrs.metadata.ejb.ArchiveInfoImpl", (String)"272", (Object)this, (Object[])new Object[]{classes, ejb, ejbInterfaceName, moduleInfo});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("getEJBWithPathClasses() exit - due to PrivilegedActionException for " + Path.class.getName() + ": " + e), (Object[])new Object[0]);
                }
                if (!tc.isEntryEnabled()) break block10;
                Tr.exit((TraceComponent)tc, (String)"getEJBWithProviderClasses", Collections.emptySet());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBWithProviderClasses", classes);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void getEJBWithPathClasses(Set<Class<?>> classes, EJBEndpoint ejb, String ejbInterfaceName, ModuleInfo moduleInfo) {
        block10: {
            String methodName = "getEJBWithPathClasses";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getEJBWithPathClasses", (Object[])new Object[]{classes});
            }
            if (classes == null && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getEJBWithPathClasses", Collections.emptySet());
            }
            try {
                Class<?> c;
                Class pathClass;
                block9: {
                    pathClass = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){
                        static final long serialVersionUID = 2698981325609573501L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Class run() throws Exception {
                            return Thread.currentThread().getContextClassLoader().loadClass(Path.class.getName());
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(3.class, null, null);
                        }
                    });
                    String ejbClassName = ejbInterfaceName == null ? ejb.getClassName() : ejbInterfaceName;
                    c = null;
                    try {
                        c = moduleInfo.getClassLoader().loadClass(ejbClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        void e;
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs.metadata.ejb.ArchiveInfoImpl", (String)"304", (Object)this, (Object[])new Object[]{classes, ejb, ejbInterfaceName, moduleInfo});
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug((TraceComponent)tc, (String)("getEJBWithPathClasses() exit - due to Class Not Found for " + ejbClassName + ": " + e), (Object[])new Object[0]);
                    }
                }
                if (c != null && c.getAnnotation(pathClass) != null) {
                    classes.add(c);
                }
            }
            catch (PrivilegedActionException pathClass) {
                FFDCFilter.processException((Throwable)pathClass, (String)"com.ibm.ws.jaxrs.metadata.ejb.ArchiveInfoImpl", (String)"315", (Object)this, (Object[])new Object[]{classes, ejb, ejbInterfaceName, moduleInfo});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("getEJBWithPathClasses() exit - due to PrivilegedActionException for " + Path.class.getName() + ": " + e), (Object[])new Object[0]);
                }
                if (!tc.isEntryEnabled()) break block10;
                Tr.exit((TraceComponent)tc, (String)"getEJBWithPathClasses", Collections.emptySet());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBWithPathClasses", classes);
        }
    }

    @ManualTrace
    private void processEJB(EJBEndpoint bean, String interfaceName, ModuleInfo moduleInfo, Set<Class<?>> classes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processEJB", (Object[])new Object[]{bean, interfaceName});
        }
        EJBBeanMetadata ejbBeanMetadata = new EJBBeanMetadata();
        if (moduleInfo instanceof EJBModuleInfo) {
            this.getApplicationSubclasses(classes, bean, moduleInfo);
            this.getEJBWithPathClasses(classes, bean, interfaceName, moduleInfo);
            this.getEJBWithProviderClasses(classes, bean, interfaceName, moduleInfo);
        }
        if (interfaceName != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting the beanInterface on the metadata.", (Object[])new Object[0]);
            }
            ejbBeanMetadata.setLocalBusinessInterface(interfaceName);
        } else {
            interfaceName = bean.getClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Interface class name is " + interfaceName), (Object[])new Object[0]);
        }
        ejbBeanMetadata.setBeanName(bean.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Storing EJBInfo for bean " + bean.getName()), (Object[])new Object[0]);
        }
        this.addEJBMetadata(interfaceName, ejbBeanMetadata);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processEJB");
        }
    }
}

