/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.util.ArrayList;

public class FFDCLogger {
    private ArrayList<String> lines;
    public static final String TAB = "  ";

    public FFDCLogger(Object invoker) {
        this(40, invoker);
    }

    public FFDCLogger(int numLines, Object invoker) {
        this.lines = new ArrayList(numLines);
        this.createFFDCHeader(invoker);
    }

    public final FFDCLogger append(String description, Object value) {
        this.lines.add(description);
        this.lines.add(new StringBuffer().append(TAB).append(value).append(AdapterUtil.EOLN).toString());
        return this;
    }

    public final FFDCLogger append(String info) {
        this.lines.add(new StringBuffer().append(info).append(AdapterUtil.EOLN).toString());
        return this;
    }

    public final FFDCLogger append(String[] moreLines) {
        int numLines = moreLines.length;
        for (int i = 0; i < numLines; ++i) {
            this.lines.add(moreLines[i]);
        }
        return this;
    }

    public FFDCLogger createFFDCHeader(Object invoker) {
        this.lines.add("_______________________________________________________________________");
        this.lines.add("");
        this.lines.add("    First Failure Data Capture information for");
        this.lines.add(new StringBuffer().append("          ").append(AdapterUtil.toString(invoker)).toString());
        this.lines.add("_______________________________________________________________________");
        this.lines.add("");
        return this;
    }

    public final FFDCLogger eoln() {
        this.lines.add("");
        return this;
    }

    public final FFDCLogger indent(Object value) {
        this.lines.add(new StringBuffer().append(TAB).append(value).toString());
        return this;
    }

    public final FFDCLogger introspect(String description, Object value) {
        if (value instanceof FFDCSelfIntrospectable) {
            this.append(((FFDCSelfIntrospectable)value).introspectSelf());
        } else {
            this.append(description, value);
        }
        return this;
    }

    public final String[] toStringArray() {
        int numLines = this.lines.size();
        String[] output = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            output[i] = this.lines.get(i);
        }
        return output;
    }
}

