/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public final class URLArray {
    private URLArray() {
    }

    public static URL[] fromPaths(final Iterable<String> files) {
        return URLArray.fromFiles(new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                final Iterator path = files.iterator();
                return new Iterator<File>(){

                    @Override
                    public boolean hasNext() {
                        return path.hasNext();
                    }

                    @Override
                    public File next() {
                        String element = (String)path.next();
                        return element == null ? null : new File(element);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public static URL[] fromFiles(Iterable<File> files) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (File file : files) {
            if (file == null) {
                result.add(null);
                continue;
            }
            try {
                result.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return result.toArray(new URL[result.size()]);
    }
}

