/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest.v1;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.Filter;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.rest.AdminCenterRestHandler;
import com.ibm.ws.ui.internal.rest.CommonJSONRESTHandler;
import com.ibm.ws.ui.internal.rest.exceptions.BadRequestException;
import com.ibm.ws.ui.internal.rest.exceptions.MethodNotSupportedException;
import com.ibm.ws.ui.internal.rest.exceptions.NoSuchResourceException;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.rest.exceptions.UserNotAuthorizedException;
import com.ibm.ws.ui.internal.rest.v1.V1Constants;
import com.ibm.ws.ui.internal.v1.ITool;
import com.ibm.ws.ui.internal.v1.IToolbox;
import com.ibm.ws.ui.internal.v1.IToolboxService;
import com.ibm.ws.ui.internal.v1.pojo.Bookmark;
import com.ibm.ws.ui.internal.v1.pojo.DuplicateException;
import com.ibm.ws.ui.internal.v1.pojo.Message;
import com.ibm.ws.ui.internal.v1.pojo.NoSuchToolException;
import com.ibm.ws.ui.internal.v1.pojo.ToolEntry;
import com.ibm.ws.ui.internal.validation.InvalidToolException;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ToolboxAPI
extends CommonJSONRESTHandler
implements V1Constants {
    private static final TraceComponent tc = Tr.register(ToolboxAPI.class);
    static final String CHILD_RESOURCE_METADATA = "_metadata";
    static final String CHILD_RESOURCE_PREFERENCES = "preferences";
    static final String CHILD_RESOURCE_TOOL_ENTRIES = "toolEntries";
    static final String CHILD_RESOURCE_BOOKMARKS = "bookmarks";
    static final String RESET_TOOLBOX_CONFIRMATION_PARAM = "resetToolbox";
    private final IToolboxService toolboxService;

    public ToolboxAPI(IToolboxService toolboxService) {
        super("/adminCenter/v1/toolbox", true, true);
        this.toolboxService = toolboxService;
    }

    protected ToolboxAPI(IToolboxService toolboxService, Filter filter, JSON jsonService) {
        super("/adminCenter/v1/toolbox", true, true, filter, jsonService);
        this.toolboxService = toolboxService;
    }

    @Trivial
    private String getUserId(RESTRequest request) {
        return request.getUserPrincipal().getName();
    }

    @Trivial
    private IToolbox getToolbox(RESTRequest request) {
        return this.toolboxService.getToolbox(this.getUserId(request));
    }

    @Override
    public boolean isKnownChildResource(String child, RESTRequest request) {
        return CHILD_RESOURCE_BOOKMARKS.equals(child) || CHILD_RESOURCE_TOOL_ENTRIES.equals(child) || CHILD_RESOURCE_METADATA.equals(child) || CHILD_RESOURCE_PREFERENCES.equals(child);
    }

    @Override
    public boolean isKnownGrandchildResource(String child, String grandchild, RESTRequest request) {
        String toolId = grandchild;
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            return this.getToolbox(request).getBookmark(toolId) != null;
        }
        if (CHILD_RESOURCE_TOOL_ENTRIES.equals(child)) {
            return this.getToolbox(request).getToolEntry(toolId) != null;
        }
        return false;
    }

    @Override
    public Object getBase(RESTRequest request, RESTResponse response) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        return this.applyFilter(request, this.getToolbox(request));
    }

    @Override
    public Object getChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (CHILD_RESOURCE_PREFERENCES.equals(child)) {
            return this.applyFilter(request, this.getToolbox(request).getPreferences());
        }
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            return this.applyFilter(request, this.getToolbox(request).getBookmarks());
        }
        if (CHILD_RESOURCE_TOOL_ENTRIES.equals(child)) {
            return this.applyFilter(request, this.getToolbox(request).getToolEntries());
        }
        if (CHILD_RESOURCE_METADATA.equals(child)) {
            return this.applyFilter(request, this.getToolbox(request).get_metadata());
        }
        throw new NoSuchResourceException();
    }

    private Object handleToolResponse(RESTRequest request, String toolId, ITool tool) throws RESTException, NoSuchResourceException {
        if (tool != null) {
            return this.applyFilter(request, tool);
        }
        Message tmsg = new Message(404, RequestNLS.formatMessage(tc, "TOOL_NOT_FOUND_TOOLBOX", toolId, this.getUserId(request)));
        throw new NoSuchResourceException("application/json; charset=UTF-8", tmsg);
    }

    @Override
    public Object getGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        String toolId = grandchild;
        if (CHILD_RESOURCE_TOOL_ENTRIES.equals(child)) {
            return this.handleToolResponse(request, toolId, this.getToolbox(request).getToolEntry(toolId));
        }
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            return this.handleToolResponse(request, toolId, this.getToolbox(request).getBookmark(toolId));
        }
        throw new NoSuchResourceException();
    }

    @Override
    @FFDCIgnore(value={DuplicateException.class, InvalidToolException.class})
    public AdminCenterRestHandler.POSTResponse postChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (CHILD_RESOURCE_TOOL_ENTRIES.equals(child)) {
            ToolEntry toAdd = this.readJSONPayload(request, ToolEntry.class);
            try {
                ToolEntry added = this.getToolbox(request).addToolEntry(toAdd);
                AdminCenterRestHandler.POSTResponse postResponse = new AdminCenterRestHandler.POSTResponse();
                postResponse.createdURL = request.getURL() + "/" + added.getId();
                postResponse.jsonPayload = added;
                return postResponse;
            }
            catch (NoSuchToolException e) {
                Message payload = new Message(400, e.getMessage());
                throw new BadRequestException("application/json; charset=UTF-8", payload);
            }
            catch (DuplicateException e) {
                Message payload = new Message(409, e.getMessage());
                throw new RESTException(409, "application/json; charset=UTF-8", payload);
            }
            catch (InvalidToolException e) {
                Message payload = new Message(400, e.getMessage());
                throw new BadRequestException("application/json; charset=UTF-8", payload);
            }
        }
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            Bookmark toAdd = this.readJSONPayload(request, Bookmark.class);
            try {
                Bookmark added = this.getToolbox(request).addBookmark(toAdd);
                AdminCenterRestHandler.POSTResponse postResponse = new AdminCenterRestHandler.POSTResponse();
                postResponse.createdURL = request.getURL() + "/" + added.getId();
                postResponse.jsonPayload = added;
                return postResponse;
            }
            catch (DuplicateException e) {
                Message payload = new Message(409, e.getMessage());
                throw new RESTException(409, "application/json; charset=UTF-8", payload);
            }
            catch (InvalidToolException e) {
                Message payload = new Message(400, e.getMessage());
                throw new BadRequestException("application/json; charset=UTF-8", payload);
            }
        }
        throw new MethodNotSupportedException();
    }

    @Override
    @FFDCIgnore(value={NoSuchToolException.class, IllegalArgumentException.class})
    public Object putChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (CHILD_RESOURCE_PREFERENCES.equals(child)) {
            IToolbox toolbox = this.getToolbox(request);
            Map preferences = this.readJSONPayload(request, Map.class);
            return toolbox.updatePreferences(preferences);
        }
        if (CHILD_RESOURCE_TOOL_ENTRIES.equals(child)) {
            ToolEntry[] listEntries = this.readJSONPayload(request, ToolEntry[].class);
            ArrayList<ToolEntry> toolEntries = new ArrayList<ToolEntry>();
            toolEntries.addAll(Arrays.asList(listEntries));
            try {
                this.getToolbox(request).updateToolEntries(toolEntries);
                return new Message(200, RequestNLS.formatMessage(tc, "TOOLBOX_UPDATE_SUCCESSFUL", new Object[0]));
            }
            catch (NoSuchToolException e) {
                Message payload = new Message(400, e.getMessage());
                throw new BadRequestException("application/json; charset=UTF-8", payload);
            }
            catch (IllegalArgumentException e) {
                Message payload = new Message(400, e.getMessage());
                throw new BadRequestException("application/json; charset=UTF-8", payload);
            }
        }
        throw new MethodNotSupportedException();
    }

    @Override
    public Object deleteBase(RESTRequest request, RESTResponse response) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        String resetToolbox = request.getParameter(RESET_TOOLBOX_CONFIRMATION_PARAM);
        if (Boolean.valueOf(resetToolbox).booleanValue()) {
            this.getToolbox(request).reset();
            return new Message(200, RequestNLS.formatMessage(tc, "TOOLBOX_RESET_SUCCESSFUL", new Object[0]));
        }
        Message msg = new Message(400, RequestNLS.formatMessage(tc, "TOOLBOX_RESET_MUST_BE_CONFIRMED", new Object[0]));
        msg.setDeveloperMessage(RequestNLS.formatMessage(tc, "TOOLBOX_RESET_MUST_BE_CONFIRMED.developeraction", new Object[0]));
        throw new BadRequestException("application/json; charset=UTF-8", msg);
    }

    @Override
    public Object deleteGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        String toolId = grandchild;
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            return this.handleToolResponse(request, toolId, this.getToolbox(request).deleteBookmark(toolId));
        }
        if (CHILD_RESOURCE_TOOL_ENTRIES.equals(child)) {
            return this.handleToolResponse(request, toolId, this.getToolbox(request).deleteToolEntry(toolId));
        }
        throw new MethodNotSupportedException();
    }
}

