/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.v1.pojo.Bookmark;
import com.ibm.ws.ui.internal.v1.utils.Utils;
import com.ibm.ws.ui.internal.validation.InvalidToolException;
import org.owasp.esapi.ESAPI;

@TraceOptions(messageBundle="com.ibm.ws.ui.internal.resources.ValidationStrings")
public class FeatureTool
extends Bookmark {
    private static final transient TraceComponent tc = Tr.register(FeatureTool.class);
    private String featureName = null;
    private String featureVersion = null;
    private String featureShortName = null;

    FeatureTool() {
        this.objectType = "featureTool";
    }

    private static String createId(String featureName, String featureVersion) {
        if (featureName != null && !featureName.isEmpty() && featureVersion != null && !featureVersion.isEmpty()) {
            return Utils.urlEncode(featureName + "-" + featureVersion);
        }
        return null;
    }

    public FeatureTool(String featureName, String featureVersion, String featureShortName, String name, String url, String icon, String description) {
        this(FeatureTool.createId(featureName, featureVersion), "featureTool", featureName, featureVersion, featureShortName, name, url, icon, description);
    }

    public FeatureTool(String id, String type, String featureName, String featureVersion, String featureShortName, String name, String url, String icon, String description) {
        super(id, type, name, url, icon, description);
        this.objectType = "featureTool";
        this.featureName = featureName;
        this.featureVersion = featureVersion;
        this.featureShortName = featureShortName;
    }

    private void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    private void setFeatureVersion(String featureVersion) {
        this.featureVersion = featureVersion;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    private void setFeatureShortName(String featureShortName) {
        this.featureShortName = featureShortName;
    }

    public String getFeatureShortName() {
        return this.featureShortName;
    }

    @Trivial
    private String listNullFields() {
        StringBuilder sb = new StringBuilder();
        if (this.featureName == null || this.featureName.isEmpty()) {
            this.addTo(sb, "featureName");
        }
        if (this.featureVersion == null || this.featureVersion.isEmpty()) {
            this.addTo(sb, "featureVersion");
        }
        return sb.toString();
    }

    private String listXSSFields() {
        StringBuilder sb = new StringBuilder();
        if (!this.containsNoXSS(this.featureName)) {
            this.addTo(sb, "featureName");
        }
        if (!this.containsNoXSS(this.featureVersion)) {
            this.addTo(sb, "featureVersion");
        }
        return sb.toString();
    }

    private boolean isValidVersion(String value) {
        return ESAPI.validator().isValidInput("VERSION", value, "UIToolVersion", Integer.MAX_VALUE, false);
    }

    @Override
    public void validateSelf() throws InvalidToolException {
        super.validateSelf(false, false);
        String badRQDfields = this.listNullFields();
        if (badRQDfields.length() != 0) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "RQD_FIELDS_MISSING", badRQDfields));
        }
        String badXSSfields = this.listXSSFields();
        if (badXSSfields.length() != 0) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "XSS_DETECTED", badXSSfields));
        }
        if (!this.isValidVersion(this.featureVersion)) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "VERSION_NOT_VALID", this.featureVersion));
        }
        String expectedId = FeatureTool.createId(this.featureName, this.featureVersion);
        if (!this.id.equals(expectedId)) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "ID_NOT_VALID", this.id, expectedId));
        }
    }

    @Override
    @Trivial
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FeatureTool) {
            FeatureTool that = (FeatureTool)o;
            boolean sameFields = true;
            sameFields &= this.featureName == that.featureName || this.featureName != null && this.featureName.equals(that.featureName);
            sameFields &= this.featureVersion == that.featureVersion || this.featureVersion != null && this.featureVersion.equals(that.featureVersion);
            return super.equals(that) && (sameFields &= this.featureShortName == that.featureShortName || this.featureShortName != null && this.featureShortName.equals(that.featureShortName));
        }
        return false;
    }

    @Override
    @Trivial
    public int hashCode() {
        return super.hashCode();
    }

    @Trivial
    String getMyJson(JSON jsonService) {
        try {
            return jsonService.stringify((Object)this);
        }
        catch (JSONMarshallException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected JSONMarshallException during Tool.toString()", (Object[])new Object[]{super.toString(), e});
            }
            return null;
        }
    }

    @Override
    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureTool {\"id\":");
        sb.append(this.getJSONString(this.id));
        sb.append(",\"type\":");
        sb.append(this.getJSONString(this.type));
        sb.append(",\"featureName\":");
        sb.append(this.getJSONString(this.featureName));
        sb.append(",\"featureVersion\":");
        sb.append(this.getJSONString(this.featureVersion));
        sb.append(",\"featureShortName\":");
        sb.append(this.getJSONString(this.featureShortName));
        sb.append(",\"name\":");
        sb.append(this.getJSONString(this.name));
        sb.append(",\"url\":");
        sb.append(this.getJSONString(this.url));
        sb.append(",\"icon\":");
        sb.append(this.getJSONString(this.icon));
        sb.append(",\"description\":");
        sb.append(this.getJSONString(this.description));
        sb.append("}");
        return sb.toString();
    }
}

