/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.v1.IToolDataService;
import com.ibm.ws.ui.internal.v1.pojo.Toolbox;
import com.ibm.ws.ui.persistence.IPersistenceProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IToolDataService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class PlainTextLoaderService
implements IToolDataService {
    private static final TraceComponent tc = Tr.register(PlainTextLoaderService.class);
    private IPersistenceProvider persistenceProviderFile;
    private IPersistenceProvider persistenceProviderCollective;
    private final Map<String, Object> syncObjects = new HashMap<String, Object>();

    @Reference(service=IPersistenceProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY, target="(com.ibm.ws.ui.persistence.provider=FILE)")
    protected synchronized void setIPersistenceProviderFILE(IPersistenceProvider provider) {
        this.persistenceProviderFile = provider;
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED_PLAINTEXT_LOADER", (Object[])new Object[]{"FILE"});
    }

    protected synchronized void unsetIPersistenceProviderFILE(IPersistenceProvider provider) {
        if (this.persistenceProviderFile == provider) {
            this.persistenceProviderFile = null;
        }
    }

    @Reference(service=IPersistenceProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(com.ibm.ws.ui.persistence.provider=COLLECTIVE)")
    protected synchronized void setIPersistenceProviderCOLLECTIVE(IPersistenceProvider provider) {
        this.persistenceProviderCollective = provider;
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED_PLAINTEXT_LOADER", (Object[])new Object[]{"COLLECTIVE"});
    }

    protected synchronized void unsetIPersistenceProviderCOLLECTIVE(IPersistenceProvider provider) {
        if (this.persistenceProviderCollective == provider) {
            this.persistenceProviderCollective = null;
        }
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED_PLAINTEXT_LOADER", (Object[])new Object[]{"FILE"});
    }

    @Activate
    protected synchronized void activate() {
    }

    @Deactivate
    protected synchronized void deactive() {
    }

    protected synchronized IPersistenceProvider getPersist() {
        if (this.persistenceProviderCollective != null) {
            return this.persistenceProviderCollective;
        }
        return this.persistenceProviderFile;
    }

    private synchronized Object getSyncObject(String encodedPersistedName) {
        Object syncObj;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSyncObject", (Object[])new Object[]{"encodedPersistedName=" + encodedPersistedName});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getSyncObject", (Object[])new Object[]{this.syncObjects.toString()});
        }
        if ((syncObj = this.syncObjects.get(encodedPersistedName)) == null) {
            syncObj = new Object();
            this.syncObjects.put(encodedPersistedName, syncObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSyncObject", (Object)syncObj);
        }
        return syncObj;
    }

    private String getEncodedPersistedName(String toolName, String userId) {
        return toolName + "/" + Toolbox.getEncodedUserId(userId);
    }

    private String getNonencodedPersistedName(String toolName, String userId) {
        return toolName + "/" + userId;
    }

    private String[] getPersistedNames(String toolName, String userId) {
        String[] persistedNames = new String[]{this.getNonencodedPersistedName(toolName, userId), this.getEncodedPersistedName(toolName, userId)};
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getPersistedNames", (Object[])new Object[]{"non-encoded file name is " + persistedNames[0]});
            Tr.debug((TraceComponent)tc, (String)"getPersistedNames", (Object[])new Object[]{"encoded file name is " + persistedNames[1]});
        }
        return persistedNames;
    }

    private void convertToEncodedPersistedName(IPersistenceProvider persistProvider, String[] persistedNames, String userId, String toolName, String toolData) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"convertToEncodedPersistedName", (Object[])new Object[]{"converting from " + persistedNames[0] + " to " + persistedNames[1]});
        }
        this.deleteToolDataFromPersistence(persistProvider, persistedNames[0], userId, toolName);
        if (this.postAndPutToolDataToPersistence(persistProvider, persistedNames[1], userId, toolName, toolData) != null) {
            Tr.info((TraceComponent)tc, (String)"TOOL_DATA_PROMOTED_TO_ENCODED_NAME", (Object[])new Object[]{toolName, userId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolData(String userId, String toolName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getToolData", (Object[])new Object[]{"userId=" + userId, "toolName=" + toolName});
        }
        String[] persistedNames = this.getPersistedNames(toolName, userId);
        Object object = this.getSyncObject(persistedNames[1]);
        synchronized (object) {
            IPersistenceProvider persistenceProvider = this.getPersist();
            String toolData = this.loadToolDataFromPersistence(persistenceProvider, persistedNames[1], userId, toolName);
            if (toolData == null) {
                toolData = this.loadToolDataFromPersistence(persistenceProvider, persistedNames[0], userId, toolName);
                if (toolData == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"The persisted tool data is not available. This is an expected code path and is likely fine.\n", (Object[])new Object[0]);
                    }
                } else if (!toolData.equals("IOException")) {
                    this.convertToEncodedPersistedName(persistenceProvider, persistedNames, userId, toolName, toolData);
                }
            }
            if (toolData != null && toolData.equals("IOException")) {
                toolData = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getToolData", (Object)toolData);
            }
            return toolData;
        }
    }

    @FFDCIgnore(value={FileNotFoundException.class})
    private String loadToolDataFromPersistence(IPersistenceProvider persist, String persistedName, String userId, String toolName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadToolDataFromPersistence", (Object[])new Object[]{"persistedName=" + persistedName});
        }
        String toolData = null;
        try {
            toolData = persist.loadPlainText(persistedName);
            Tr.info((TraceComponent)tc, (String)"LOADED_PERSISTED_TOOL_DATA", (Object[])new Object[]{userId, toolName});
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_TOOL_DATA_ACCESS", (Object[])new Object[]{userId, toolName});
            toolData = "IOException";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadToolDataFromPersistence", (Object)toolData);
        }
        return toolData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteToolData(String userId, String toolName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteToolData", (Object[])new Object[]{"userId=" + userId, "toolName=" + toolName});
        }
        String[] persistedNames = this.getPersistedNames(toolName, userId);
        boolean deletedFromCollective = true;
        boolean deletedFromFile = true;
        Object object = this.getSyncObject(persistedNames[1]);
        synchronized (object) {
            for (String persistedName : persistedNames) {
                if (this.persistenceProviderCollective != null) {
                    boolean bl = deletedFromCollective = this.deleteToolDataFromPersistence(this.persistenceProviderCollective, persistedName, userId, toolName) && deletedFromCollective;
                }
                if (this.persistenceProviderFile == null) continue;
                deletedFromFile = this.deleteToolDataFromPersistence(this.persistenceProviderFile, persistedName, userId, toolName) && deletedFromFile;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteToolData", (Object)(deletedFromCollective && deletedFromFile ? 1 : 0));
        }
        return deletedFromCollective && deletedFromFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addToolData(String userId, String toolName, String toolData) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addToolData", (Object[])new Object[]{"userId=" + userId, "toolName=" + toolName});
        }
        String encodedPersistedName = this.getEncodedPersistedName(toolName, userId);
        Object object = this.getSyncObject(encodedPersistedName);
        synchronized (object) {
            return this.postAndPutToolDataToPersistence(this.getPersist(), encodedPersistedName, userId, toolName, toolData);
        }
    }

    private boolean deleteToolDataFromPersistence(IPersistenceProvider persist, String persistedName, String userId, String toolName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"deleteToolDataFromPersistence", (Object[])new Object[]{"persistedName=" + persistedName});
        }
        try {
            boolean ret = true;
            if (persist != null && persist.exists(persistedName) && (ret = persist.delete(persistedName))) {
                Tr.info((TraceComponent)tc, (String)"DELETED_PERSISTED_TOOL_DATA", (Object[])new Object[]{userId, toolName});
            }
            return ret;
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_PERSISTED_TOOL_DATA", (Object[])new Object[]{userId, toolName});
            return false;
        }
    }

    private String postAndPutToolDataToPersistence(IPersistenceProvider persist, String persistedName, String userId, String toolName, String toolData) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"postAndPutToolDataToPersistence", (Object[])new Object[]{"persistedName=" + persistedName});
        }
        try {
            persist.storePlainText(persistedName, toolData);
            Tr.info((TraceComponent)tc, (String)"POSTED_TOOL_DATA", (Object[])new Object[]{userId, toolName});
            return toolData;
        }
        catch (JSONMarshallException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_POST_TOOL_JSON_DATA_CONTENT", (Object[])new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_POST_TOOL_DATA_CONTENT", (Object[])new Object[]{userId});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String userId, String toolName) {
        String encodedPersistedName = this.getEncodedPersistedName(toolName, userId);
        Object object = this.getSyncObject(encodedPersistedName);
        synchronized (object) {
            if (this.persistenceProviderCollective != null) {
                return this.persistenceProviderCollective.exists(encodedPersistedName);
            }
            return this.persistenceProviderFile.exists(encodedPersistedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promoteIfPossible(String userId, String toolName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"promoteIfPossible", (Object[])new Object[]{"userId=" + userId, "toolName=" + toolName});
        }
        String[] persistedNames = this.getPersistedNames(toolName, userId);
        Object object = this.getSyncObject(persistedNames[1]);
        synchronized (object) {
            if (this.persistenceProviderCollective != null && !this.persistenceProviderCollective.exists(persistedNames[1]) && !this.promoteIfPossible(persistedNames[1], persistedNames[1], userId, toolName)) {
                this.promoteIfPossible(persistedNames[0], persistedNames[1], userId, toolName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"promoteIfPossible");
        }
    }

    private boolean promoteIfPossible(String fromPersistedName, String toPersistedName, String userId, String toolName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"promoteIfPossible", (Object[])new Object[]{"fromPersistedName=" + fromPersistedName, "toPersistedName=" + toPersistedName});
        }
        boolean promoted = false;
        if (this.persistenceProviderFile.exists(fromPersistedName)) {
            try {
                String data = this.loadToolDataFromPersistence(this.persistenceProviderFile, fromPersistedName, userId, toolName);
                if (data != null && !"IOException".equals(data)) {
                    this.persistenceProviderCollective.storePlainText(toPersistedName, data);
                    promoted = true;
                }
            }
            catch (IOException e) {
                Tr.error((TraceComponent)tc, (String)"UNABLE_TO_PROMOTE_TOOL_DATA_CONTENT", (Object[])new Object[]{userId, toolName});
            }
            catch (JSONMarshallException e) {
                Tr.error((TraceComponent)tc, (String)"UNABLE_TO_PROMOTE_TOOL_JSON_DATA_CONTENT", (Object[])new Object[]{e.getMessage()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"promoteIfPossible", (Object)promoted);
        }
        return promoted;
    }
}

