/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.v1.pojo.Bookmark;
import com.ibm.ws.ui.internal.v1.utils.URLUtility;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;

public class URLUtilityImpl
implements URLUtility {
    private static final TraceComponent tc = Tr.register(URLUtilityImpl.class);
    private static final Pattern titlePattern = Pattern.compile("<title>(.*?)</title>");
    private static final Pattern descPattern = Pattern.compile("<meta name=\"[Dd]escription\".*?content=\"(.*?)\"");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private int httpGETStatus(URL url) throws RESTException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                int n = 200;
                return n;
            }
            int n = conn.getResponseCode();
            return n;
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException caught while trying to resolve URL " + url.toString() + " -- some possible expected cases are: UnknownHostException (the URL host is not resolvable), ConnectException (the connection timed out or was otherwise rejected), SocketException or SSLHandshakeException (the request was over the HTTPS protocol which we don't support)"), (Object[])new Object[]{e});
            }
            int n = 404;
            return n;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public Map<String, Object> getStatus(URL url) throws RESTException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("url", url.toString());
        payload.put("status", this.httpGETStatus(url));
        return payload;
    }

    private void closeCloseable(Closeable c) {
        block3: {
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"Error closing Closeable", (Object[])new Object[]{e});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={IOException.class})
    public Map<String, Object> analyzeURL(URL url) {
        boolean couldReachURL = true;
        URLConnection connection = null;
        InputStream cis = null;
        ByteArrayOutputStream bos = null;
        String name = "";
        String description = "";
        String icon = "images/tools/defaultTool_142x142.png";
        try {
            connection = url.openConnection();
            try {
                Matcher descMatcher;
                byte[] bytes = new byte[4096];
                cis = connection.getInputStream();
                bos = new ByteArrayOutputStream();
                while (cis.read(bytes) >= 0) {
                    bos.write(bytes);
                }
                String urlContent = bos.toString("UTF-8");
                Matcher titleMatcher = titlePattern.matcher(urlContent);
                if (titleMatcher.find()) {
                    name = titleMatcher.group(1);
                }
                if ((descMatcher = descPattern.matcher(urlContent)).find()) {
                    description = descMatcher.group(1);
                }
                this.closeCloseable(bos);
                this.closeCloseable(cis);
            }
            catch (Throwable throwable) {
                this.closeCloseable(bos);
                this.closeCloseable(cis);
                throw throwable;
            }
        }
        catch (IOException e) {
            couldReachURL = false;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("urlReachable", couldReachURL);
        payload.put("tool", new Bookmark(name, url.toString(), icon, description));
        return payload;
    }
}

